package gov.va.med.mhv.sso;

import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.util.ResponseUtil;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

public class FedCredCspAction extends Action {
	private static final Log logger = LogFactoryUtil.getLog(EAuthGateway.class);
	private FedCredSsoUtil fedCredSsoUtil = new FedCredSsoUtil();

	public void processCspOnlySSo(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		String edipiValue = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ICN_PARAM);
		String firstName = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.FIRST_NAME);
		String lastName = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.LAST_NAME);
		String birthDate = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.BIRTH_DATE);
		String ssn = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.FIRST_NAME);
		String middleName = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.MIDDLE_NAME);
		String gender = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.MIDDLE_NAME);
		String idType = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ID_TYPE);
		String icn = fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.ICN_PARAM);

		PatientDTO patient = null;
		
		// JAZZ Story #144874 Federated Credential - RemoteID Proofing - CSP
		// Only Traits
		if (fedCredSsoUtil.isEdipiExist(edipiValue)) {
			if (!fedCredSsoUtil.isEdipiValid(edipiValue)) {
				fedCredSsoUtil.logInfo(logger, "Edipi is not valid, going to error page icn:" + icn);
				
				fedCredSsoUtil.addErrorMessage(fedCredSsoUtil.INVALID_EDIPI_MSG);

				response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
				return;
			}

			if (!fedCredSsoUtil.isEdipiMultiple(edipiValue)) {
				fedCredSsoUtil.logInfo(logger, "Edipi returns multiple vlaue, going to error page icn:" + icn);
				
				fedCredSsoUtil.addErrorMessage(fedCredSsoUtil.MULTIPLE_EDIPIS_MSG);
				response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
				return;
			}

			// JAZZ Story #144874 Federated Credential - RemoteID Proofing -
			// EDIPI is provided and valid
			// If the record is found, check to see if MHV IEN is provided.
			// If not provided,

			// Jazz Id: 230989 - adding HL7v3 Version code in MVI Request
			// Header.
			ResponseUtil<PatientDTO> responseUtil = new ResponseUtil<PatientDTO>();
			fedCredSsoUtil.searchInMVIWithEdipi(edipiValue, response);
			
			if(responseUtil.isFailure()) {
				fedCredSsoUtil.logInfo(logger, "Error in searchInMVIWithEdipi going to error page icn:" + icn);
				return;
			}

			patient = responseUtil.getPojoObject();
			
			if(patient != null) {
				fedCredSsoUtil.logInfo(logger, "searchInMVIWithEdipi returns patient icn:" + icn);

				if(fedCredSsoUtil.isUserAccountDeactivated(patient.getUserProfile().getUserName())) {
					fedCredSsoUtil.logInfo(logger, "user account is deactivated, going to MHV Login page icn:" + icn);
					
					fedCredSsoUtil.processDeactivatedAccount(patient, request);
					response.sendRedirect(fedCredSsoUtil.getMhvLoginUrl());
					return;
				}
				
				fedCredSsoUtil.processFacilitiesUpdate(patient);
			} else {
				fedCredSsoUtil.logInfo(logger, "searchInMVIWithEdipi returns no patient icn:" + icn);
				
				if (fedCredSsoUtil.isNotFound(firstName) || fedCredSsoUtil.isNotFound(lastName)
						|| fedCredSsoUtil.isNotFound(birthDate) || fedCredSsoUtil.isNotFound(ssn)) {
					
					fedCredSsoUtil.logInfo(logger, "searchInMVIWithEdipi returns patient icn:" + icn);
					
					fedCredSsoUtil.addErrorMessage(fedCredSsoUtil.NOT_FOUND_ERROR_MSG);
					response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
				}
				
				middleName = fedCredSsoUtil.processMiddleName(middleName);
				gender = fedCredSsoUtil.processGender(gender);
				ssn = fedCredSsoUtil.processSsn(ssn);
	
				// If SSN is not 9 digit, MHV will show error msg
				if (!fedCredSsoUtil.isSsnValid(ssn, idType)) {
					fedCredSsoUtil.logInfo(logger, "Invalid SSN - Going to Error page icn:" + icn);
					fedCredSsoUtil.addErrorMessage(fedCredSsoUtil.INVALID_SSN_MSG);
					response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
				}
	
				// birth date is not in Date format, MHV will show error msg
				if (!fedCredSsoUtil.isDate(birthDate)) {
					fedCredSsoUtil.logInfo(logger, "Invalid DOB - Going to Error page icn:" + icn);
					fedCredSsoUtil.addErrorMessage(fedCredSsoUtil.INVALID_DOB_MSG);
					response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
				}
	
				// JAZZ Story #144874 Federated Credential - RemoteID Proofing -
				// Check MHV for existing accoutns with the same
				// first name, last name, SSN, and DOB.
				fedCredSsoUtil.logInfo(logger, "Finding the user with traits in MHV for icn" + icn);
				UserProfileDTO uProfile = fedCredSsoUtil.findUserProfile(firstName, lastName, gender, ssn, birthDate);
				if (uProfile != null) {
					if (fedCredSsoUtil.isUserAccountDeactivated(uProfile)) {
						fedCredSsoUtil.logInfo(logger, "Account is deactivated - Going to MHV Login page icn:" + icn);
						fedCredSsoUtil.processDeactivatedAccount(fedCredSsoUtil.getPatient(uProfile.getId()), request);
						response.sendRedirect(fedCredSsoUtil.getMhvLoginUrl());
						return;
					}
					fedCredSsoUtil.logInfo(logger, "Found an active user with traits in MHV" + icn);
					// JAZZ Story #144874 Federated Credential - RemoteID
					// Proofing - Notify User Existing MHV Account with
					// their Personal Data Already exists
					// goToReauthPage(req, res, uProfile.getUserName());
					response.sendRedirect(fedCredSsoUtil.getReauthPageUrl());
					return;
				} else {
					if (fedCredSsoUtil.isICNValid(icn)) {
						patient = fedCredSsoUtil.findPatientByIcn(icn, response);
						if (patient != null) {
	
							// Discussion with Carnetta: 3/26/2015 Check for the
							// SSN. If SSN is different,
							// then display the error message and take him out
							if (uProfile != null && ssn!=null && !ssn.equals(uProfile.getSsn().replaceAll("[\\s\\-()]", ""))) {
								fedCredSsoUtil.logInfo(logger, "Invalid SSN - Going to Error page icn:" + icn);
								fedCredSsoUtil.addErrorMessage(FedCredSsoUtil.INVALID_SSN_MSG);
								response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
								return;
							}
	
							fedCredSsoUtil.logInfo(logger, "Found Account by ICN in MHV - Going to Connect page icn:" + icn);
							response.sendRedirect(fedCredSsoUtil.getReauthPageUrl());
							return;
						}
					} else {
						fedCredSsoUtil.logInfo(logger, "Invalid ICN - Going to Error page icn:" + icn);
						fedCredSsoUtil.addErrorMessage(FedCredSsoUtil.INVALID_ICN_MSG);
						response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
						return;
					}
	
					fedCredSsoUtil.logInfo(logger, "Calling get corresponding id to MVI with traits" + icn);
					// mviPatRes =
					// gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createMviIntegrationServiceDelegate().
					// searchPersonInMVIForUSAA(firstName, middleName, lastName,
					// birthDate, gender, ssn);
					// Jazz Id: 230989 - adding HL7v3 Version code in MVI Request
					// Header.
					responseUtil = new ResponseUtil<PatientDTO>();
					fedCredSsoUtil.logInfo(logger, "searchInMVIWithIcn icn:" + icn);
					fedCredSsoUtil.searchInMVIWithIcn(icn, response);
					if(responseUtil.isFailure()) {
						fedCredSsoUtil.logInfo(logger, "searchInMVIWithIcn failed going to error page icn:" + icn);
						return;
					}
					
					patient = responseUtil.getPojoObject();
					if(patient != null) {
						fedCredSsoUtil.logInfo(logger, "searchInMVIWithIcn found record going to connect page icn:" + icn);
						response.sendRedirect(fedCredSsoUtil.getConnectePageUrl());
						return;
					}
				}
			}
		}else {
			// If "NOT_FOUND" is sent in "first name", "last name" , "birth
			// date", "ssn" and "gender" , MHV will show error msg
			if (fedCredSsoUtil.isNotFound(firstName) || fedCredSsoUtil.isNotFound(lastName)
					|| fedCredSsoUtil.isNotFound(birthDate) || fedCredSsoUtil.isNotFound(ssn)) {
				fedCredSsoUtil.logInfo(logger, "Error in traits going to error page icn:" + icn);
				fedCredSsoUtil.addErrorMessage(FedCredSsoUtil.NOT_FOUND_ERROR_MSG);
				response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
			}

			fedCredSsoUtil.processMiddleName(middleName);
			fedCredSsoUtil.processGender(gender);
			fedCredSsoUtil.processSsn(ssn);

			// If SSN is not 9 digit, MHV will show error msg
			if (!fedCredSsoUtil.isSsnValid(ssn, idType)) {
				fedCredSsoUtil.logInfo(logger, "Invalid SSN going to error page icn:" + icn);
				fedCredSsoUtil.addErrorMessage(fedCredSsoUtil.INVALID_SSN_MSG);
				response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
			}

			// birth date is not in Date format, MHV will show error msg
			if (!fedCredSsoUtil.isDate(birthDate)) {
				fedCredSsoUtil.logInfo(logger, "Invalid DOB going to error page icn:" + icn);
				fedCredSsoUtil.addErrorMessage(fedCredSsoUtil.INVALID_DOB_MSG);
				response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
			}

			// JAZZ Story #144874 Federated Credential - RemoteID Proofing -
			// Initial MVI GetCorresponding IDs
			fedCredSsoUtil.logInfo(logger, "searchPersonInMVIByTraits icn:" + icn);

			ResponseUtil<PatientDTO> responseUtil = new ResponseUtil<PatientDTO>();
			fedCredSsoUtil.logInfo(logger, "searchInMVIWithTraits icn:" + icn);
			fedCredSsoUtil.searchInMVIWithTraits(firstName, middleName,
					lastName, birthDate, gender, ssn, response);
			
			patient = responseUtil.getPojoObject();
			
			if (responseUtil.isFailure()) {
				fedCredSsoUtil.logInfo(logger, "searchInMVIWithTraits failed going to error page icn:" + icn);
				return;
			} else if(patient != null) {	
				UserProfileDTO uProfile = patient.getUserProfile();
				if (fedCredSsoUtil.isUserAccountDeactivated(uProfile)) {
					fedCredSsoUtil.logInfo(logger, "user account is deactivated going to login page icn:" + icn);
					fedCredSsoUtil.processDeactivatedAccount(patient, request);
					response.sendRedirect(fedCredSsoUtil.getMhvLoginUrl());
					return;
				}
				fedCredSsoUtil.processFacilitiesUpdate(patient);
			} else {
				// JAZZ Story #144874 Federated Credential - RemoteID Proofing -
				// Check MHV for existing accoutns with the same
				// first name, last name, SSN, and DOB.
				fedCredSsoUtil.logInfo(logger, "findUserProfile(firstName, lastName, gender, ssn, birthDate) icn:" + icn);
				UserProfileDTO uProfile = fedCredSsoUtil.findUserProfile(firstName, lastName, gender, ssn, birthDate);
				if (uProfile != null) {
					fedCredSsoUtil.logInfo(logger, "uProfile != null icn:" + icn);
					if (fedCredSsoUtil.isUserAccountDeactivated(uProfile)) {
						fedCredSsoUtil.logInfo(logger, "user account is deactivated going to login page icn:" + icn);
						patient = fedCredSsoUtil.getPatient(uProfile.getId());
						fedCredSsoUtil.processDeactivatedAccount(patient, request);
						response.sendRedirect(fedCredSsoUtil.getMhvLoginUrl());
						return;
					}
					// JAZZ Story #144874 Federated Credential - RemoteID
					// Proofing - Notify User Existing MHV Account with
					// their Personal Data Already exists
					fedCredSsoUtil.logInfo(logger, "found user by traits in MHV going to reauth page icn:" + icn);
					response.sendRedirect(fedCredSsoUtil.getReauthPageUrl());
					return;
				} else {
					fedCredSsoUtil.logInfo(logger, "uProfile == null icn:" + icn);
					if (fedCredSsoUtil.isICNValid(icn)) {
						patient = fedCredSsoUtil.findPatientByIcn(icn, response);
						if (patient != null) {
							uProfile = patient.getUserProfile();

							// Discussion with Carnetta: 3/26/2015 Check for the
							// SSN. If SSN is different,
							// then display the error message and take him out
							if (!ssn.equals(uProfile.getSsn().replaceAll("[\\s\\-()]", ""))) {
								fedCredSsoUtil.logInfo(logger, "Invalid SSN going to error page icn:" + icn);
								fedCredSsoUtil.addErrorMessage(fedCredSsoUtil.INVALID_SSN_MSG);
								response.sendRedirect(fedCredSsoUtil.getErrorPageUrl());
								return;
							}

							fedCredSsoUtil.logInfo(logger, "found user by icn in MHV going to reauth page icn:" + icn);
							response.sendRedirect(fedCredSsoUtil.getReauthPageUrl());
							return;
						}
					}
				}

				fedCredSsoUtil.logInfo(logger, "searchPersonInMVIByICN icn:" + icn);
				
				// mviPatRes =
				// gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createMviIntegrationServiceDelegate().
				// searchPersonInMVIForUSAA(firstName, middleName, lastName,
				// birthDate, gender, ssn);
				// Jazz Id: 230989 - adding HL7v3 Version code in MVI Request
				// Header.
				responseUtil = new ResponseUtil<PatientDTO>();
				fedCredSsoUtil.searchInMVIWithIcn(icn, response);
				if(responseUtil.isFailure()) {
					fedCredSsoUtil.logInfo(logger, "searchPersonInMVIByICN failed going error page icn:" + icn);
					return;
				}
				
				patient = responseUtil.getPojoObject();
				if(patient != null) {
					fedCredSsoUtil.logInfo(logger, "searchPersonInMVIByICN found record going connect page icn:" + icn);
					response.sendRedirect(fedCredSsoUtil.getConnectePageUrl());
					return;
				}
			}
		}
		
		InPersonAuthenticationDTO ipa = null; 
		
		if(patient.getIpas().iterator().hasNext()) {
			ipa = patient.getIpas().iterator().next();
		}
		
		if(ipa == null) {
			fedCredSsoUtil.logInfo(logger, "IPA not found for icn:" + icn);
			response.sendRedirect(fedCredSsoUtil.getAnonymousUrl());
			return;
		} else if(fedCredSsoUtil.isIpaAuthenticated(ipa)) {
			fedCredSsoUtil.logInfo(logger, "IPA is authenticated for icn:" + icn);
			fedCredSsoUtil.processFacilitiesUpdate(ipa.getPatient());
			fedCredSsoUtil.processLastLogin(ipa.getPatient().getUserProfile(), fedCredSsoUtil.retrieveVAFFIProperty(request, FedCredSsoUtil.CSID_PARAM));
			fedCredSsoUtil.determineDeepLinkingPage(response);
			return;
		} else {
			if(fedCredSsoUtil.goToOnlineAuthenticationPage(patient, request)) {
				fedCredSsoUtil.logInfo(logger, "Going to Online Authentication Page icn:" + icn);
				response.sendRedirect(fedCredSsoUtil.getOnlineAuthenticationUrl());
				return;
			} 
			fedCredSsoUtil.logInfo(logger, "Going to MHV Logged In Page icn:" + icn);
			response.sendRedirect(fedCredSsoUtil.getMHVLoggedInUrl());
			return;
		}
	}

	@Override
	public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
		try {
			processCspOnlySSo(request, response);
		} catch (Exception e) {
			e.printStackTrace();
			throw new ActionException();
		}	
	}
}
